﻿Public Class BoundingBoxRenderer

    Public Effect As BasicEffect
    Private verts(7) As VertexPositionColor
    Private vertDecl As VertexDeclaration

    Private indices() As Short = {
  0, 1,
  1, 2,
  2, 3,
  3, 0,
  0, 4,
  1, 5,
  2, 6,
  3, 7,
  4, 5,
  5, 6,
  6, 7,
  7, 4
 }

    
    Public Sub Render(BBox As BoundingBox, device As GraphicsDevice, view As Matrix, projection As Matrix, c As Color)
        If Me.Effect Is Nothing Then
            Me.Effect = New BasicEffect(device)
        End If
        Me.Effect.VertexColorEnabled = True
        Me.Effect.LightingEnabled = False
        Me.Effect.EmissiveColor = c.ToVector3
        Dim corners() As Vector3 = BBox.GetCorners
        For i As Integer = 0 To 7
            Me.verts(i).Position = corners(i)
            Me.verts(i).Color = c
        Next
        Me.Effect.View = view
        Me.Effect.Projection = projection
        For Each pass As EffectPass In Me.Effect.CurrentTechnique.Passes
            pass.Apply()
            Using buffer As New VertexBuffer(device, VertexPositionColor.VertexDeclaration, Me.verts.Length, BufferUsage.WriteOnly)
                buffer.SetData(Me.verts.ToArray)
                device.SetVertexBuffer(buffer)
            End Using
            device.DrawUserIndexedPrimitives(Of VertexPositionColor)(PrimitiveType.LineList, verts, 0, 8, indices, 0, 12)
        Next
    End Sub

End Class
